import { system } from "@minecraft/server";
import { SlugBuckets } from "../item/SlugBuckets.js";
import { MinecraftLiquid } from "../utils/MinecraftLiquid.js";
import { AbstractBucketableEntity } from "./AbstractBucketableEntity.js";

export class Slug extends AbstractBucketableEntity {
  static IDENTIFIER = 'sf_nba:slug';

  static BOUNCE_PLAYER = 'sf_nba:should_bounce_player';

  constructor() {
    super(Slug.IDENTIFIER, SlugBuckets, 'minecraft:bucket', MinecraftLiquid.None, {
      empty: 'sf_nba.bucket.fill_slug',
      fill: 'sf_nba.bucket.empty_slug',
    });

    this.bouncePlayer();
  }

  bouncePlayer() {
    system.afterEvents.scriptEventReceive.subscribe((e) => {
      const entity = e.sourceEntity;
      const playerName = e.message;

      if (entity == null) return;
      if (entity.typeId === undefined) return;
      if (entity.typeId !== this.identifier) return;
      if (e.id !== AbstractBucketableEntity.BOUNCE_PLAYER) return;
    
      const player = e.sourceEntity.dimension.getPlayers({ name: playerName })[0];

      if (player == null) return;

      if (player.getVelocity().y < 0) {
        player.applyKnockback(0, 0, 0, 0.8);
      } else {
        entity.triggerEvent('sf_nba:can_detect_bounce')
      }
    });
  }
}

new Slug();